package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.model.entity.InfinityApiDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.*;
import com.elitescloud.cloudt.system.util.BeanUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.Collections;
import java.util.List;

import static com.elitescloud.cloudt.system.common.AuthMethod.*;
import static com.elitescloud.cloudt.system.common.MediaType.*;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:17
 * @Description:
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinityApiConvert {

    InfinityApiConvert INSTANCE = Mappers.getMapper(InfinityApiConvert.class);

    /**
     * DO => DetailVO
     */
    List<InfinityApiDetailVO> doToVO(List<InfinityApiDO> infinityApiDOS);

    /**
     * DO => DetailVO
     */
    @Mapping(target = "headerParam", source = "headerParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "queryParam", source = "queryParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "pathParam", source = "pathParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "bodyParam", expression = "java(toObjectColumn(infinityApiDO.getMediaType(), infinityApiDO" +
            ".getBodyParam()))")
    @Mapping(target = "response", source = "response", qualifiedByName = "valueToJsonColumn")
    InfinityApiDetailVO doToVO(InfinityApiDO infinityApiDO);

    /**
     * MergeVO => DetailVO
     */
    @Mapping(target = "headerParam", source = "headerParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "queryParam", source = "queryParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "pathParam", source = "pathParam", qualifiedByName = "valueToFormColumn")
    @Mapping(target = "bodyParam", expression = "java(toObjectColumn(apiMergeVO.getMediaType(), apiMergeVO" +
            ".getBodyParam()))")
    @Mapping(target = "response", source = "response", qualifiedByName = "valueToJsonColumn")
    @Mapping(target = "serverUrl", expression = "java(inheritServerUrl(apiMergeVO))")
    @Mapping(target = "authMethod", expression = "java(inheritAuthMethod(apiMergeVO))")
    @Mapping(target = "authAccount", expression = "java(inheritAuthAccount(apiMergeVO))")
    InfinityApiDetailVO mergeToDetailVO(InfinityApiMergeVO apiMergeVO);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "headerParam", source = "headerParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "queryParam", source = "queryParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "pathParam", source = "pathParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "bodyParam", source = "bodyParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "response", source = "response", qualifiedByName = "saveParamToStr")
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    InfinityApiDO saveParamToDO(ApiSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    @Mapping(target = "headerParam", source = "headerParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "queryParam", source = "queryParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "pathParam", source = "pathParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "bodyParam", source = "bodyParam", qualifiedByName = "saveParamToStr")
    @Mapping(target = "response", source = "response", qualifiedByName = "saveParamToStr")
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    void saveParamMergeToDO(ApiSaveParamVO saveParam, @MappingTarget InfinityApiDO infinityApiDO);

    /**
     * 对象参数 => 字符串参数
     */
    @Named("saveParamToStr")
    default <T> String saveParamToStr(T saveParam) {
        if (ObjectUtil.isNull(saveParam)) {
            return null;
        }
        // JsonStr or saveParam.toString()
        return BeanUtils.toJsonOptional(saveParam).orElse(String.valueOf(saveParam));
    }

    /**
     * DO字符串 => 表单参数
     */
    @Named("valueToFormColumn")
    default List<FormColumnDefinition> valueToFormColumn(String value) {
        if (StrUtil.isBlank(value)) {
            return Collections.emptyList();
        }
        return BeanUtils.toList(value, FormColumnDefinition.class);
    }

    /**
     * DO字符串 => JSON参数
     */
    @Named("valueToJsonColumn")
    default JsonColumnDefinition valueToJsonColumn(String value) {
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return BeanUtils.toBean(value, JsonColumnDefinition.class);
    }

    /**
     * DO字符串 => Object
     */
    @Named("toObjectColumn")
    default Object toObjectColumn(String mediaType, String bodyParam) {
        if (mediaType.equals(MIME_NONE.getCode())) {
            return null;
        }
        if (List.of(MIME_MULTIPART_FORM_DATA.getCode(), MIME_FORM_URLENCODED.getCode()).contains(mediaType)) {
            return BeanUtils.toMapList(bodyParam);
        }
        if (mediaType.equals(MIME_JSON_UTF8.getCode())) {
            return BeanUtils.toMap(bodyParam);
        }
        return bodyParam;
    }

    @Named("authAccountToStr")
    default String authAccountToStr(ApiSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return saveParam.getAuthAccount();
    }

    @Named("inheritServerUrl")
    default String inheritServerUrl(InfinityApiMergeVO apiMergeVO) {
        if (StrUtil.isNotBlank(apiMergeVO.getApiServerUrl())) {
            return apiMergeVO.getApiServerUrl();
        }
        if (StrUtil.isNotBlank(apiMergeVO.getFolderServerUrl())) {
            return apiMergeVO.getFolderServerUrl();
        }
        return apiMergeVO.getPlatformServerUrl();
    }

    @Named("inheritAuthMethod")
    default String inheritAuthMethod(InfinityApiMergeVO apiMergeVO) {
        if (!apiMergeVO.getApiAuthMethod().equals(AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getApiAuthMethod();
        }
        if (StrUtil.isNotBlank(apiMergeVO.getFolderAuthMethod())
                && !apiMergeVO.getFolderAuthMethod().equals(AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getFolderAuthMethod();
        }
        return apiMergeVO.getPlatformAuthMethod();
    }

    @Named("inheritAuthAccount")
    default String inheritAuthAccount(InfinityApiMergeVO apiMergeVO) {
        if (!apiMergeVO.getApiAuthMethod().equals(AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getApiAuthAccount();
        }
        if (StrUtil.isNotBlank(apiMergeVO.getFolderAuthMethod())
                && !apiMergeVO.getFolderAuthMethod().equals(AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getFolderAuthAccount();
        }
        return apiMergeVO.getPlatformAuthAccount();
    }
}
