package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.model.entity.InfinityPlatformDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.*;
import com.elitescloud.cloudt.system.util.BeanUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.List;

import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_BASIC_AUTH;
import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_OAUTH_V2;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 14:31
 * @Description:
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinityPlatformConvert {
    InfinityPlatformConvert INSTANCE = Mappers.getMapper(InfinityPlatformConvert.class);


    /**
     * DO => PageVO
     */
    List<ThirdApiPagingVO> toPageVO(List<InfinityPlatformDO> platformDO);

    /**
     * DO => PageVO
     */
    @Mapping(target = "basicAuthAccount", expression = "java(toBasicAuthAccount(platformDO))")
    @Mapping(target = "oauth2Account", expression = "java(toOAuthAccount(platformDO))")
    ThirdApiPagingVO toPageVO(InfinityPlatformDO platformDO);

    /**
     * DO => RespVO
     */
    List<ThirdApiRespVO> doToVO(List<InfinityPlatformDO> platformDO);

    /**
     * DO => RespVO
     */
    @Mapping(target = "basicAuthAccount", expression = "java(toBasicAuthAccount(platformDO))")
    @Mapping(target = "oauth2Account", expression = "java(toOAuthAccount(platformDO))")
    ThirdApiRespVO doToVO(InfinityPlatformDO platformDO);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    InfinityPlatformDO saveParamToDO(ThirdApiSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    void saveParamMergeToDO(ThirdApiSaveParamVO saveParam, @MappingTarget InfinityPlatformDO infinityPlatformDO);

    @Named("authAccountToStr")
    default String authAccountToStr(ThirdApiSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return "";
    }

    @Named("toBasicAuthAccount")
    default BasicAuthAccountVO toBasicAuthAccount(InfinityPlatformDO platformDO) {
        if (StrUtil.isBlank(platformDO.getAuthAccount())) {
            return null;
        }
        if (platformDO.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(platformDO.getAuthAccount(), BasicAuthAccountVO.class);
        }
        return null;
    }

    @Named("toOAuthAccount")
    default OAuth2AccountVO toOAuthAccount(InfinityPlatformDO platformDO) {
        if (StrUtil.isBlank(platformDO.getAuthAccount())) {
            return null;
        }
        if (platformDO.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(platformDO.getAuthAccount(), OAuth2AccountVO.class);
        }
        return null;
    }
}
