package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/5/9
 */
@Entity
@Table(name = "sys_user_company", indexes = {
        @Index(name = "idx_sys_user_company_user_id", columnList = "sysUserId"),
        @Index(name = "idx_sys_user_company_ou_id", columnList = "ouId"),
})
@Comment("用户与公司关联表")
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class SysUserCompanyDO extends BaseModel {
    private static final long serialVersionUID = 7843811073375222496L;

    @Comment("用户ID")
    @Column()
    private Long sysUserId;

    @Comment("公司ID")
    @Column()
    private Long ouId;

    @Comment("公司编码")
    @Column()
    private String ouCode;

    @Comment("公司名称")
    @Column()
    private String ouName;

    @Comment("绑定时间")
    @Column()
    private LocalDateTime bindTime;
}
