package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/28
 */
@Entity
@Table(name = "sys_user_terminal", indexes = {
        @Index(name = "idx_sys_user_terminal_user", columnList = "userId"),
})
@Comment("用户与终端的关联")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SysUserTerminalDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8405391688121950321L;

    @Comment("用户ID")
    @Column()
    private Long userId;

    @Comment("终端编码，Terminal枚举类")
    @Column()
    private String terminalCode;

    @Comment("绑定时间")
    @Column()
    private LocalDateTime timeBind;
}
