package com.elitescloud.cloudt.system.model.vo.query.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 数据关系查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@Getter
@Setter
@ApiModel(description = "数据关系查询参数")
public class CommonDataRelationQueryVO implements Serializable {
    private static final long serialVersionUID = 6038539591838536584L;

    /**
     * 数据关系编码
     */
    @NotBlank(message = "数据关系编码为空")
    @ApiModelProperty(value = "数据关系编码", position = 1, required = true)
    private String drCode;

    /**
     * 分类编码
     */
    @ApiModelProperty(value = "分类编码", position = 2)
    private String catCode;

    /**
     * 数据的标识
     */
    @ApiModelProperty(value = "数据的标识", position = 3)
    private String dataKey;

    /**
     * 数据的检索属性
     */
    @ApiModelProperty(value = "数据的检索属性", position = 4)
    private String dataAttribute;

    /**
     * 数据的扩展信息
     * <p>
     * 不为空时，根据扩展信息进行检索，全部扩展信息都满足才符合条件
     */
    @ApiModelProperty(value = "数据的扩展信息", position = 4)
    private Map<String, String> dataExt;
}
