package com.elitescloud.cloudt.system.model.vo.query.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 员工通用查询参数.
 *
 * @author Kaiser（wang shao）
 * 2022/11/2
 */
@Data
@ApiModel(description = "员工通用查询参数")
public class CommonEmployeePageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 8470391356443617414L;

    /**
     * 当前租户组织下的员工
     */
    @ApiModelProperty(value = "当前租户组织下的员工", position = 0)
    private Boolean currentTenantOrg;

    /**
     * 指定组织下的员工[直属]
     */
    @ApiModelProperty(value = "指定组织下的员工[直属]", position = 1)
    private Long orgId;

    /**
     * 当前组织下的员工[直属]
     */
    @ApiModelProperty(value = "当前组织下的员工[直属]", position = 1)
    private Boolean currentOrg;

    /**
     * 指定组织下的所属员工[下属]
     */
    @ApiModelProperty(value = "指定组织下的所属员工[下属]", position = 2)
    private Long orgIdBelong;

    /**
     * 当前组织下的所属员工[下属]
     */
    @ApiModelProperty(value = "组织ID[下属]", position = 2)
    private Long currentOrgBelong;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 3)
    private String code;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 4)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 5)
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 6)
    private String gender;

    /**
     * 电话
     */
    @ApiModelProperty(value = "办公电话", position = 7)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "工作邮箱", position = 8)
    private String email;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 9)
    private Boolean enabled;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职，默认是", position = 10)
    private Boolean served;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型[udc]cloudt-system:employeeType", position = 11)
    private String type;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "员工角色", position = 12)
    private String roleCode;

    /**
     * 入职起始时间
     */
    @ApiModelProperty(value = "入职起始时间", position = 13)
    private LocalDateTime joinTimeStart;

    /**
     * 入职截止时间
     */
    @ApiModelProperty(value = "入职截止时间", position = 13)
    private LocalDateTime joinTimeEnd;

    /**
     * 是否拥有登录账号
     */
    @ApiModelProperty(value = "是否拥有登录账号", position = 14)
    private Boolean hasAccount;

    /**
     * 是否返回员工的组织
     */
    @ApiModelProperty(value = "是否返回所在组织", position = 31)
    private Boolean withOrg;

    /**
     * 是否返回员工角色
     */
    @ApiModelProperty(value = "是否返回员工角色", position = 32)
    private Boolean withRole;
}
