package com.elitescloud.cloudt.system.model.vo.query.extend;

import com.el.coordinator.core.common.jpa.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 导入导出记录查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@Data
@ApiModel(description = "导入导出记录查询参数")
public class TmplImportQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3606651156127412728L;

    @ApiModelProperty(value = "导入用户ID", hidden = true)
    private Long userId;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "模板编码")
    private String tmplCode;

    @ApiModelProperty(value = "是否是导出模板")
    private Boolean export;

    @ApiModelProperty(value = "导出时间-起始")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "导出时间-截止")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "是否结束")
    private Boolean finish;

    @ApiModelProperty(value = "是否成功")
    private Boolean succ;
}
