package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.cloudt.system.common.BusinessObjectNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 业务对象树信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/18
 */
@Getter
@Setter
@ApiModel(description = "业务对象树信息")
public class BusinessObjectTreeNodeRespVO extends TreeRespParam<BusinessObjectTreeNodeRespVO> {
    private static final long serialVersionUID = -495121667253795398L;

    @ApiModelProperty(value = "节点类型")
    private BusinessObjectNodeType nodeType;

    @ApiModelProperty(value = "图标")
    private String icon;

    @ApiModelProperty(value = "是否是挂载节点")
    private Boolean refNode;

    @ApiModelProperty(value = "关联的权限节点")
    private String refPermission;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "请求方式")
    private String apiMethod;

    @ApiModelProperty(value = "请求url")
    private String apiUrl;
}
