package com.elitescloud.cloudt.system.model.vo.resp.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 项目版本分页查询结果信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/2
 */
@Getter
@Setter
@ApiModel(description = "项目版本分页查询结果信息")
public class ProjectVersionPageRespVO implements Serializable {
    private static final long serialVersionUID = 3501094315865050062L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "项目编码")
    private String project;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "环境编码")
    private String env;

    @ApiModelProperty(value = "项目名称")
    private String envName;

    @ApiModelProperty(value = "应用编码")
    private String applicationCode;

    @ApiModelProperty(value = "应用名称")
    private String applicationName;

    @ApiModelProperty(value = "jdk版本")
    private String javaVersion;

    @ApiModelProperty(value = "Spring版本")
    private String springVersion;

    @ApiModelProperty(value = "SpringBoot版本")
    private String springBootVersion;

    @ApiModelProperty(value = "云梯架构版本")
    private String cloudtBootVersion;

    @ApiModelProperty(value = "项目版本号")
    private String projectVersion;

    @ApiModelProperty(value = "操作系统")
    private String osName;

    @ApiModelProperty(value = "构建时间")
    private String buildTime;

    @ApiModelProperty(value = "上报者IP")
    private String reporterIp;

    @ApiModelProperty(value = "首次上报时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最后上报时间")
    private LocalDateTime reportTime;
}
