package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 数据权限字段.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@ApiModel(description = "数据权限字段")
@Getter
@Setter
public class DataPermissionFieldRespVO implements Serializable {
    private static final long serialVersionUID = 905290874114633793L;

    /**
     * 字段名称
     */
    @ApiModelProperty(value = "字段名称", position = 1)
    private String fieldName;

    /**
     * 字段描述
     */
    @ApiModelProperty(value = "字段描述", position = 2)
    private String fieldRemark;

    @ApiModelProperty(value = "实体字段", position = 3)
    private Boolean entity;

    /**
     * 权限-可读
     */
    @ApiModelProperty(value = "权限-可读", position = 11)
    private Boolean readable;

    /**
     * 权限-可写
     */
    @ApiModelProperty(value = "权限-可写", position = 12)
    private Boolean writeable;
}
