package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 数据权限保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
@ApiModel(description = "数据权限信息")
public class SysDprRespVO implements Serializable {
    private static final long serialVersionUID = -8220968718281066641L;

    /**
     * 数据范围
     */
    @ApiModelProperty(value = "数据范围", position = 1)
    private String range;

    /**
     * 自定义规则列表
     */
    @ApiModelProperty(value = "自定义规则列表", position = 2)
    private List<SysDprApiCustomRuleRespVO> customRuleList;

    /**
     * 字段权限列表
     */
    @ApiModelProperty(value = "字段权限列表", position = 3)
    private List<SysDprApiFieldRespVO> fieldList;

    /**
     * 接口入参列表
     */
    @ApiModelProperty(value = "接口入参列表", position = 4)
    private List<SysDprApiFieldRespVO> argList;
}
