package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.List;
import java.util.Map;

import static com.elitescloud.cloudt.system.common.MediaType.*;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:05
 * @Description:
 */
@Data
@Builder
@ApiModel(value = "接口请求参数")
public class HttpParam {

    @ApiModelProperty(value = "业务主键")
    private String bizKey;

    @JsonIgnore
    @ApiModelProperty(value = "平台编码")
    public String getPlatformCode() {
        return apiConfig.getPlatformCode();
    }

    @JsonIgnore
    @ApiModelProperty(value = "接口编码")
    public String getApiCode() {
        return apiConfig.getApiCode();
    }

    @ApiModelProperty(value = "接口地址")
    private String url;

    public String getUrl() {
        return apiConfig.getServerUrl() + apiConfig.getApiUrl();
    }

    @ApiModelProperty(value = "认证方式")
    private String authMethod;

    public String getAuthMethod() {
        return apiConfig.getAuthMethod();
    }

    @ApiModelProperty(value = "请求方式")
    @Enumerated(EnumType.STRING)
    private HttpMethod requestMethod;

    public HttpMethod getRequestMethod() {
        return apiConfig.getRequestMethod();
    }

    @ApiModelProperty(value = "请求头的媒体类型")
    private String mediaType;

    public String getMediaType() {
        return apiConfig.getMediaType();
    }

    @ApiModelProperty(value = "接口配置")
    private InfinityApiDetailVO apiConfig;

    @ApiModelProperty(value = "header参数")
    private MultiValueMap<String, String> headerParam;

    @ApiModelProperty(value = "查询参数")
    private MultiValueMap<String, String> queryParam;

    @ApiModelProperty(value = "路径参数")
    private Map<String, String> pathParam;

    @ApiModelProperty(value = "body参数")
    private Object bodyParam;

    @ApiModelProperty(value = "formdata参数")
    private MultiValueMap<String, Object> formParam;

    /**
     * 是否需要传body参数
     */
    @JsonIgnore
    public boolean needBodyParam() {
        return !getMediaType().equals(MIME_NONE.getCode()) &&
                (ObjectUtil.isNotNull(getBodyParam()) || ObjectUtil.isNotNull(getFormParam()));
    }

    /**
     * 是否 form-data
     */
    @JsonIgnore
    public boolean formData() {
        return List.of(MIME_MULTIPART_FORM_DATA.getCode(), MIME_FORM_URLENCODED.getCode()).contains(getMediaType());
    }

    /**
     * 不需要转换
     */
    @JsonIgnore
    public boolean objectData() {
        return List.of(MIME_JSON_UTF8.getCode(), MIME_TEXT_PLAIN.getCode()).contains(getMediaType());
    }

    @JsonIgnore
    public BodyInserters.MultipartInserter getBodyFormData() {
        return BodyInserters.fromMultipartData(formParam);
    }

}
