package com.elitescloud.cloudt.system.model.vo.resp.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 三方接口详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/15
 */
@Data
@ApiModel(description = "三方接口详细信息")
public class ThirdApiLogDetailRespVO implements Serializable {
    private static final long serialVersionUID = 4278330152038430319L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 2)
    private String appCode;

    /**
     * 是否内部调用
     */
    @ApiModelProperty(value = "是否内部调用", position = 3)
    private Boolean server;

    /**
     * 服务端地址
     */
    @ApiModelProperty(value = "服务端地址", position = 4)
    private String serverAddr;

    /**
     * 第三方应用名称
     */
    @ApiModelProperty(value = "第三方应用名称", position = 5)
    private String thirdApp;

    /**
     * 源系统
     */
    @ApiModelProperty(value = "源系统", position = 5)
    private String sourceSystem;

    /**
     * 是否内部调用
     */
    @ApiModelProperty(value = "目标系统", position = 5)
    private String targetSystem;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型", position = 6)
    private String businessType;

    /**
     * 业务数据标识
     */
    @ApiModelProperty(value = "业务数据标识", position = 7)
    private String businessKey;

    /**
     * 请求用户ID
     */
    @ApiModelProperty(value = "请求用户ID", position = 8)
    private Long userId;

    /**
     * 请求用户
     */
    @ApiModelProperty(value = "请求用户", position = 9)
    private String username;

    /**
     * 请求的接口地址
     */
    @ApiModelProperty(value = "请求的接口地址", position = 10)
    private String uri;

    /**
     * 请求方式
     */
    @ApiModelProperty(value = "请求方式", position = 11)
    private HttpMethod reqMethod;

    /**
     * 请求的查询参数
     */
    @ApiModelProperty(value = "请求的查询参数", position = 12)
    private String reqQueryParamsJson;

    /**
     * 请求体
     */
    @ApiModelProperty(value = "请求体", position = 13)
    private String reqBody;

    /**
     * 请求头
     */
    @ApiModelProperty(value = "请求头", position = 14)
    private String reqHeadersJson;

    /**
     * 是否请求成功
     */
    @ApiModelProperty(value = "是否请求成功", position = 15)
    private Boolean reqSuccess;

    /**
     * 请求失败信息
     */
    @ApiModelProperty(value = "请求失败信息", position = 16)
    private String reqFailMsg;

    /**
     * 请求时间
     */
    @ApiModelProperty(value = "请求时间", position = 17)
    private LocalDateTime reqTime;

    /**
     * 响应体
     */
    @ApiModelProperty(value = "响应体", position = 18)
    private String respBody;

    /**
     * 是否响应成功
     */
    @ApiModelProperty(value = "是否响应成功", position = 19)
    private Boolean respSuccess;

    /**
     * 响应失败信息
     */
    @ApiModelProperty(value = "响应失败信息", position = 20)
    private String respFailMsg;

    /**
     * 响应时间
     */
    @ApiModelProperty(value = "响应时间", position = 21)
    private LocalDateTime respTime;

    /**
     * 重试失败原因
     */
    @ApiModelProperty(value = "重试失败原因", position = 22)
    private String retryFailReason;

    /**
     * 是否是手动重试
     */
    @ApiModelProperty(value = "是否是手动重试", position = 23)
    private Boolean manualRetry;

    /**
     * 重试参数
     */
    @ApiModelProperty(value = "重试参数", position = 31)
    private RetryParamVO retryParam;

    @ApiModel(value = "ThirdApiLogDetailRespVO.RetryParamVO", description = "重试参数")
    @Data
    public static class RetryParamVO implements Serializable {
        private static final long serialVersionUID = 8045654400389544882L;
        /**
         * 服务端地址
         * <p>
         * 为空则取当前服务的地址（不包含路由）
         */
        @ApiModelProperty(value = "服务地址", position = 1)
        private String serverAddr;

        /**
         * 请求的接口地址
         */
        @ApiModelProperty(value = "请求的接口地址", position = 2)
        private String uri;

        /**
         * 请求方式
         */
        @ApiModelProperty(value = "请求方式", position = 3)
        private HttpMethod reqMethod;

        /**
         * 请求的查询参数
         */
        @ApiModelProperty(value = "请求的查询参数", position = 4)
        private String reqQueryParamsJson;

        /**
         * 请求体
         */
        @ApiModelProperty(value = "请求体", position = 5)
        private String reqBody;

        /**
         * 请求头
         */
        @ApiModelProperty(value = "请求头", position = 6)
        private String reqHeadersJson;
    }
}
