package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.elitescloud.cloudt.system.common.AuthMethod;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:36
 * @Description: 接口平台(对接系统)
 */

@Data
@ApiModel("接口平台(对接系统)")
public class ThirdApiPagingVO implements Serializable {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台名称")
    private String platformName;

    @ApiModelProperty(value = "平台编码")
    private String platformCode;

    @ApiModelProperty(value = "服务url前缀")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    private String authMethod;

    @ApiModelProperty(value = "认证方式中文")
    private String authMethodName;

    public String getAuthMethodName() {
        return AuthMethod.fromCode(authMethod);
    }

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "记录创建者id")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者id")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;
}
