package com.elitescloud.cloudt.system.model.vo.resp.index;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户授权字段.
 *
 * @author Kaiser（wang shao）
 * @date 4/7/2023
 */
@Data
@ApiModel(description = "用户授权字段")
public class UserFieldRespVO implements Serializable {
    private static final long serialVersionUID = -663015116233616981L;

    /**
     * 授权字段记录ID
     */
    @ApiModelProperty(value = "授权字段记录ID", position = 1)
    private Long id;

    /**
     * 字段名称
     */
    @ApiModelProperty(value = "字段名称", position = 2)
    private String fieldName;

    /**
     * 字段描述
     */
    @ApiModelProperty(value = "字段描述", position = 3)
    private String fieldRemark;

    /**
     * API控制-可见
     */
    @ApiModelProperty(value = "API控制-可见", position = 4)
    private Boolean fieldApiVisible;

    /**
     * 表单控制-可见
     */
    @ApiModelProperty(value = "表单控制-可见", position = 5)
    private Boolean fieldFormVisible;

    /**
     * 表单控制-可编辑
     */
    @ApiModelProperty(value = "表单控制-可编辑", position = 6)
    private Boolean fieldFormUpdate;
}
