package com.elitescloud.cloudt.system.model.vo.resp.index;

import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 用户菜单.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
public class UserMenuRespVO implements Serializable {
    private static final long serialVersionUID = 3055937072594610715L;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1)
    private String menuCode;

    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;

    /**
     * 父节点编码
     */
    @ApiModelProperty(value = "父菜单编码", position = 3)
    private String parentMenuCode;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标", position = 4)
    private String menusIcon;

    /**
     * 路由地址
     */
    @ApiModelProperty(value = "路由地址", position = 5)
    private String route;

    /**
     * 节点类型
     */
    @ApiModelProperty(value = "节点类型", position = 6)
    private String nodeType;

    @ApiModelProperty(value = "数据实际类型", position = 6)
    private String dataType;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 7)
    private Integer sortNo;

    /**
     * 是否显示
     */
    @ApiModelProperty(value = "是否显示", position = 8)
    private Boolean display;

    /**
     * 是否外链接
     */
    @ApiModelProperty(value = "是否外链接", position = 9)
    private Boolean outerLink;

    /**
     * 外链接类型
     */
    @ApiModelProperty(value = "外链接类型", position = 9)
    private PlatformMenusOuterLinkTypeEnum outerLinkType;


    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否有子节点", position = 11)
    private Boolean hasChildren;

    /**
     * 子节点列表
     */
    @ApiModelProperty(value = "子节点列表", position = 12)
    private List<UserMenuRespVO> children;


    public String getParentMenuCode() {
        if (!StringUtils.hasText(parentMenuCode)) {
            return null;
        }
        return parentMenuCode;
    }

    public Boolean getHasChildren() {
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return hasChildren;
    }
}
