package com.elitescloud.cloudt.system.model.vo.resp.org;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工的组织信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工的组织信息")
public class EmployeeOrgInfoRespVO extends CustomFieldAbstractVo implements Serializable {
    private static final long serialVersionUID = 4774497806183249327L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 1)
    private Long id;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 2)
    private String code;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型", position = 3)
    private String type;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称", position = 3)
    private String typeName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 4)
    private String duty;

    /**
     * 员工照片
     */
    @ApiModelProperty(value = "员工照片", position = 5)
    private String photo;

    /**
     * 合同起始时间
     */
    @ApiModelProperty(value = "合同起始时间", position = 6)
    private LocalDateTime contractStartTime;

    /**
     * 合同截止时间
     */
    @ApiModelProperty(value = "合同截止时间", position = 7)
    private LocalDateTime contractEndTime;

    /**
     * 入职时间
     */
    @ApiModelProperty(value = "入职时间", position = 8)
    private LocalDateTime joinTime;

    /**
     * 办公电话
     */
    @ApiModelProperty(value = "办公电话", position = 9)
    private String phoneWork;

    /**
     * 工作邮箱
     */
    @ApiModelProperty(value = "工作邮箱", position = 10)
    private String emailWork;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 11)
    private Boolean enabled;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否在职", position = 12)
    private Boolean served;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 13)
    private Integer sortNo;

    /**
     * 所在组织
     */
    @ApiModelProperty(value = "所在组织", position = 21)
    private List<EmpOrgRespVO> orgList;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 31)
    private String remark;
}
