package com.elitescloud.cloudt.system.model.vo.resp.sys;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/5
 */
@Data
@ApiModel(description = "OpenApi分页查询信息")
public class OpenApiPageRespVO implements Serializable {
    private static final long serialVersionUID = -5954028605372774459L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "OpenApi编码", position = 1, hidden = true)
    private String openApiCode;

    @ApiModelProperty(value = "项目编码", position = 2, hidden = true)
    private String project;

    @ApiModelProperty(value = "项目名称", position = 2, hidden = true)
    private String projectName;

    @ApiModelProperty(value = "环境编码", position = 3, hidden = true)
    private String env;

    @ApiModelProperty(value = "环境名称", position = 3, hidden = true)
    private String envName;

    @ApiModelProperty(value = "应用编码", position = 4)
    private String appCode;

    @ApiModelProperty(value = "应用名称", position = 4)
    private String appName;

    @ApiModelProperty(value = "标题", position = 5)
    private String title;

    @ApiModelProperty(value = "描述", position = 6)
    private String description;

    @ApiModelProperty(value = "OpenAPI构建时间", position = 7)
    private LocalDateTime buildTime;

    @ApiModelProperty(value = "项目版本", position = 8)
    private String projectVersion;

    @ApiModelProperty(value = "架构版本", position = 8)
    private String cloudtBootVersion;

    @ApiModelProperty(value = "状态", position = 9)
    private String state;
    @ApiModelProperty(value = "状态名称", position = 9)
    private String stateName;

    @ApiModelProperty(value = "失败原因", position = 10)
    private String failReason;

    @ApiModelProperty(value = "接口数量", position = 11)
    private Long operationNum;

    @ApiModelProperty(value = "业务对象数量", position = 12)
    private Long businessObjectNum;

    @ApiModelProperty(value = "RPC接口数量", position = 12)
    private Long feignOperationNum;

    @ApiModelProperty(value = "业务对象状态", position = 13)
    private String businessObjectState;
    @ApiModelProperty(value = "业务对象状态名称", position = 13)
    private String businessObjectStateName;

    @ApiModelProperty(value = "业务对象构建时间", position = 14)
    private LocalDateTime businessObjectEndUpdateTime;

    @ApiModelProperty(value = "创建时间", position = 21)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间", position = 22)
    private LocalDateTime modifyTime;
}
