package com.elitescloud.cloudt.system.model.vo.resp.user;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/19
 */
@Data
@ApiModel(description = "用户列表信息")
public class UserListRespVO implements Serializable {
    private static final long serialVersionUID = 3880453221583386101L;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 1)
    private Long id;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 2)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 4)
    private String fullName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String lastName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String firstName;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称", position = 6)
    private String nickName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 7)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 8)
    private String email;

    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }
}
