package com.elitescloud.cloudt.system.model.vo.save.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 数据关系的保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
@ApiModel(description = "数据关系的保存信息")
public class DataRelationInstSaveVO implements Serializable {
    private static final long serialVersionUID = 6508071530240856599L;

    @NotBlank(message = "数据关系编码为空")
    @ApiModelProperty(value = "数据关系编码", position = 1, required = true)
    private String drCode;

    @NotEmpty(message = "主数据的标识为空")
    @ApiModelProperty(value = "主数据的标识", position = 3, required = true)
    private List<String> dataKeyList;

    @ApiModelProperty(value = "分类数据列表", position = 4)
    @Valid
    private List<CatData> catList;

    @Getter
    @Setter
    @ApiModel(value = "DataRelationInstSaveVO_CatData", description = "数据关系的分类保存的值")
    public static class CatData implements Serializable {
        private static final long serialVersionUID = 4757008415237192345L;

        @ApiModelProperty(value = "分类编码", position = 1, required = true)
        private String catCode;

        @ApiModelProperty(value = "主数据的检索属性", position = 2)
        private String dataAttribute;

        @ApiModelProperty(value = "主数据的扩展信息，键值对，可选", position = 3)
        private Map<String, String> dataExt;

        @ApiModelProperty(value = "数据值列表", position = 11)
        private List<InstData> dataList;
    }

    @Getter
    @Setter
    @ApiModel(value = "DataRelationInstSaveVO_InstData", description = "数据关系的保存的值")
    public static class InstData implements Serializable {
        private static final long serialVersionUID = 4757008415237192345L;

        @NotBlank(message = "关联数据的标识为空")
        @ApiModelProperty(value = "关联数据的标识", position = 1, required = true)
        private String refDataKey;

        @ApiModelProperty(value = "关联数据的检索属性", position = 2)
        private String refDataAttribute;

        @ApiModelProperty(value = "关联数据的扩展信息，键值对", position = 11)
        private Map<String, String> refDataExt;
    }
}
