package com.elitescloud.cloudt.system.model.vo.save.dpr;

import com.elitescloud.cloudt.system.constant.DataPermissionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 数据权限保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/27
 */
@Getter
@Setter
@ApiModel(description = "数据权限保存信息")
public class DataPermissionSaveVO implements Serializable {
    private static final long serialVersionUID = -6333681144923096727L;

    @ApiModelProperty(value = "角色编码", position = 1, required = true)
    @NotBlank(message = "角色编码为空")
    private String roleCode;

    @ApiModelProperty(value = "权限类型", position = 2, required = true)
    @NotNull(message = "权限类型为空")
    private DataPermissionType permissionType;

    @ApiModelProperty(value = "菜单编码", position = 3)
    private String menuCode;

    @ApiModelProperty(value = "业务操作编码", position = 4)
    private String operationCode;

    @ApiModelProperty(value = "业务对象编码", position = 5)
    private String businessObjectCode;

    @ApiModelProperty(value = "应用编码", position = 5)
    private String appCode;

    @ApiModelProperty(value = "是否使用引用的权限规则", position = 6)
    private Boolean useRef;

    @ApiModelProperty(value = "自定义规则列表", position = 11)
    @Valid
    private List<DataPermissionRuleSaveVO> customRuleList;

    @ApiModelProperty(value = "字段权限列表", position = 21)
    @Valid
    private List<DataPermissionFieldSaveVO> fieldList;
}
