package com.elitescloud.cloudt.system.model.vo.save.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 数据权限批量保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
@ApiModel(description = "数据权限批量保存信息")
public class SysDprBatchSaveVO implements Serializable {
    private static final long serialVersionUID = -8220968718281066642L;

    /**
     * 角色ID
     */
    @ApiModelProperty(value = "角色ID", position = 1, required = true)
    @NotNull(message = "角色ID为空")
    private Long roleId;

    /**
     * 菜单API信息
     */
    @ApiModelProperty(value = "菜单API信息", position = 2, required = true)
    @NotEmpty(message = "菜单API为空")
    private List<MenuApiSaveVO> menuApiList;

    /**
     * 自定义规则列表
     */
    @ApiModelProperty(value = "自定义规则列表", position = 3)
    @Valid
    private List<SysDprApiCustomRuleSaveVO> customRuleList;

    /**
     * 保存策略
     */
    @ApiModelProperty(value = "保存策略(APPEND: 直接追加规则，默认策略; CLEAR: 清空原有策略; REPLACE: 替换原有策略)", position = 4)
    private String saveStrategy;

    @Data
    @ApiModel(value = "SysDprBatchSaveVO_MenuApiSaveVO", description = "菜单接口信息")
    public static class MenuApiSaveVO implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 菜单编码
         */
        @ApiModelProperty(value = "菜单编码", position = 1, required = true)
        @NotBlank(message = "菜单编码为空")
        private String menuCode;

        /**
         * 接口编码
         */
        @ApiModelProperty(value = "接口编码", position = 2, required = true)
        @NotBlank(message = "接口编码为空")
        private String apiCode;

    }
}
