package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 汇率保存参数.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "汇率保存参数")
public class CurrencyRateSaveVO {
    /**
     * 记录ID，编辑时不可为空
     */
    @ApiModelProperty(value = "记录ID，编辑时不可为空", position = 1)
    private Long id;

    /**
     * 自货币码
     */
    @ApiModelProperty(value = "自货币码", position = 2, required = true)
    @NotBlank(message = "自货币为空")
    private String fromCurr;

    /**
     * 自货币名称
     */
    @ApiModelProperty(value = "自货币码", position = 2, required = true)
    @NotBlank(message = "自货币为空")
    private String fromCurrName;

    /**
     * 至货币码
     */
    @ApiModelProperty(value = "至货币码", position = 4, required = true)
    @NotBlank(message = "至货币为空")
    private String toCurr;

    /**
     * 至货币名称
     */
    @ApiModelProperty(value = "至货币码", position = 4, required = true)
    @NotBlank(message = "至货币为空")
    private String toCurrName;

    /**
     * 汇率
     */
    @ApiModelProperty(value = "汇率", position = 6, required = true)
    @NotNull(message = "汇率为空")
    private BigDecimal ratio;

    /**
     * 算法
     */
    @ApiModelProperty(value = "算法", position = 7, required = true)
    @NotBlank(message = "算法为空")
    private String calMethod;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;

    /**
     * 有效时间-起始
     */
    @ApiModelProperty(value = "有效时间-起始", position = 9)
    private LocalDateTime validFrom;

    /**
     * 有效时间-截止
     */
    @ApiModelProperty(value = "有效时间-截止", position = 10)
    private LocalDateTime validTo;
}
