package com.elitescloud.cloudt.system.model.vo.save.message;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/24
 */
@Getter
@Setter
@ApiModel(description = "测试消息信息")
public class MsgTestSaveVO implements Serializable {
    private static final long serialVersionUID = 5105502309652364591L;

    @NotBlank(message = "模板编码为空")
    @ApiModelProperty(value = "模板编码", position = 1, required = true)
    private String templateCode;

    @ApiModelProperty(value = "发送人，默认取当前用户", position = 11)
    private UserAccount sendUser;

    @ApiModelProperty(value = "接收人", position = 12)
    private List<UserAccount> receivers;

    @ApiModelProperty(value = "抄送人", position = 13)
    private List<UserAccount> carbonUsers;

    @ApiModelProperty(value = "回执账号", position = 14)
    private UserAccount receiptAccount;

    @ApiModelProperty(value = "标题参数，键值对", position = 21)
    private Map<String, String> titleParams;

    @ApiModelProperty(value = "内容参数，键值对", position = 22)
    private Map<String, String> contentParams;

    @ApiModelProperty(value = "业务参数，键值对", position = 23)
    private Map<String, String> businessParams;

    @ApiModelProperty(value = "附件编码", position = 24)
    private List<String> fileCodes;

    @Getter
    @Setter
    @ApiModel(value = "MsgTestSaveVO_UserAccount", description = "用户账户信息")
    public static class UserAccount implements Serializable {
        private static final long serialVersionUID = -9044906235630216859L;

        @ApiModelProperty(value = "用户ID", position = 1)
        private Long userId;

        @ApiModelProperty(value = "登录号", position = 2)
        private String username;

        @ApiModelProperty(value = "姓名", position = 2)
        private String lastName;

        @ApiModelProperty(value = "手机号", position = 3)
        private String mobile;

        @ApiModelProperty(value = "邮箱", position = 4)
        private String email;
    }
}
