package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 角色复制信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "角色复制信息")
public class RoleCloneSaveVO implements Serializable {
    private static final long serialVersionUID = -7459845778606513377L;

    /**
     * ID
     */
    @ApiModelProperty(value = "原角色ID", required = true)
    @NotNull(message = "请选择原角色")
    private Long originalId;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码", position = 1, required = true)
    @NotBlank(message = "角色编码为空")
    private String code;

    /**
     * 编号编码
     */
    @ApiModelProperty(value = "角色名称", position = 2, required = true)
    @NotBlank(message = "角色名称为空")
    private String name;

    /**
     * 分组ID
     */
    @ApiModelProperty(value = "分组ID", position = 3)
    private Long groupId;

    @ApiModelProperty(value = "上级角色编码", position = 4)
    private String parentCode;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 4)
    private Boolean enabled;

    /**
     * 业务标识，[UDC]cloudt-system:roleBusiness
     */
    @ApiModelProperty(value = "业务标识，[UDC]cloudt-system:roleBusiness", position = 5)
    private String businessKey;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 11)
    private String remark;

    @ApiModelProperty(value = "是否复制功能权限，默认是", position = 12)
    private Boolean withSec;

    @ApiModelProperty(value = "是否复制数据权限，默认是", position = 13)
    private Boolean withDataSec;
}
