package com.elitescloud.cloudt.system.model.vo.save.user;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 用户详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@ApiModel(description = "用户详细信息")
@Data
public class UserSaveVO extends CustomFieldAbstractVo implements Serializable {
    private static final long serialVersionUID = -305970628122366622L;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 1)
    private Long id;

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号", position = 2)
    private String username;

    /**
     * 外部唯一标识
     */
    @ApiModelProperty(value = "外部唯一标识", position = 2)
    private String outerKey;

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "密码，传参则修改密码", position = 3)
    private String password;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 4, required = true)
    @NotBlank(message = "姓名为空")
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别（MALE-男，FEMALE-女，SECRET-保密）", position = 5)
    private String gender;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称", position = 6)
    private String nickName;

    /**
     * 生日
     */
    @ApiModelProperty(value = "生日", position = 7)
    private LocalDate birthDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 8)
    private String mobile;

    /**
     * 个人邮箱
     */
    @ApiModelProperty(value = "个人邮箱", position = 9)
    private String email;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 10)
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "账号过期时间", position = 11)
    private LocalDateTime expiredTime;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号", position = 12)
    private String idCard;

    /**
     * 所在地
     */
    @ApiModelProperty(value = "所在地", position = 13)
    private AreaVO areaVO;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址", position = 16)
    private String address;

    /**
     * 允许登录终端
     */
    @ApiModelProperty(value = "允许登录终端（BACKEND-管理端，APP-移动端，APPLET-小程序）", position = 17, hidden = true)
    private Set<String> terminals;

    /**
     * 个性签名
     */
    @ApiModelProperty(value = "个性签名", position = 21)
    private String personalSign;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 22)
    private String remark;

    /**
     * 账号类型
     */
    @ApiModelProperty(value = "账号类型", position = 31)
    private List<UserType> userTypes;

    @Getter
    @Setter
    public static class UserType implements Serializable {
        private static final long serialVersionUID = 5832769603207861816L;

        @ApiModelProperty(value = "账号类型，[UDC]cloudt-system:userType", position = 1)
        private String type;

        @ApiModelProperty(value = "用户身份标识ID", position = 2)
        private String identityId;
    }
}
