package com.elitescloud.cloudt.system.model.vo.sbean;

import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author : chen
 *  返回列规则的列字段 extends SysDpcrApiFieldsDO
 * 2022-11-25 17:05
 */
@Data
@SearchBean(
        tables = TableNameConstant.SYS_DPCR_API_FIELDS_DO + " rarg"
        ,       // 两表关联
        where = "rarg.delete_flag = 0",
        autoMapTo = "rarg"
)
public class SysDpcrApiFiledsBean  {

    @ApiModelProperty(name = "id",notes = "")
    private Long id ;
    @ApiModelProperty(name = "角色id",notes = "")
    private Long roleId ;

    @ApiModelProperty(name = "appid",notes = "")
    private Long appId ;

    @ApiModelProperty(name = "菜单编码",notes = "")
    private String menuCode ;

    @ApiModelProperty(name = "apiId",notes = "")
    private Long apiId ;

    @ApiModelProperty(name = "字段名称",notes = "")
    private String fieldName ;

    @ApiModelProperty(name = "字段描述",notes = "")
    private String fieldRemark ;

    @ApiModelProperty(name = "api可见",notes = "")
    private Boolean fieldApiVisible ;

    @ApiModelProperty(name = "表单可见",notes = "")
    private Boolean fieldFormVisible ;

    @ApiModelProperty(name = "表单可编辑",notes = "")
    private Boolean fieldFormUpdate;
}
