package com.elitescloud.cloudt.system.modules.message.controller;

import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.*;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 消息模板管理
 * @date : 2023/5/23 12:28
 */
@Api(tags = "【测试】消息模板管理-消息发送测试")
@RestController
@RequestMapping(value = "/openApi/msg/sysMsgSend", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@SuppressWarnings({"deprecation", "removal"})
public class SysMsgTemplateOpenApiController {

    private final SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();

    public SysMsgTemplateOpenApiController(SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService) {
        this.sysMsgTemplateSendRpcService = sysMsgTemplateSendRpcService;
    }


    @PostMapping("/sendEmployee")
    @ApiOperation(value = "消息模板-员工消息发送")
    @ApiOperationSupport(order = 1)
    public ApiResult<String> sendEmployee(@RequestBody TemplateEmployeeSendParamDTO dto) {
        return  sysMsgTemplateSendRpcService.msgTemplateEmployeeSend(dto);
    }



    @PostMapping("/sendEmployeeDemo")
    @ApiOperation(value = "消息模板-员工消息发送样例测试，后台组织好了固定参数，参数")
    @ApiOperationSupport(order = 99)
    public ApiResult<String> sendEmployeeDemo(@RequestBody TemplateEmployeeSendParamDTO dto) {
        if(StringUtils.isBlank(dto.getTemplateCode())) {
            dto.setTemplateCode("test1");
        }
        //设置模板动态标题替换
        Map<String, String> titleTemplateParams = new HashMap<>();
        titleTemplateParams.put("name", "标题替换部分");
        dto.setTitleReplaceMap(titleTemplateParams);

        //设置模板动态内容替换
        Map<String, String> contentTemplateParams = new HashMap<>();
        contentTemplateParams.put("name", "测试模板邮件替换name");
        dto.setContentReplaceMap(contentTemplateParams);

        //设置发送人 start
        MsgSendEmployeeUserDTO sendUser= MsgSendEmployeeUserDTO.builder()
                .userCode("adminCode")
                .userName("admin")
                .userId(26183177199419838L)
                .build();
        dto.setSendUser(sendUser);
        //发送人 end

        //设置接收人，userId是员工ID
        List<MsgRecipientUserDTO> recipientUserList= new ArrayList<>();
        MsgRecipientUserDTO recipient1= MsgRecipientUserDTO.builder()
                .userId(26515388624798699L)
                .userName("niuchen1234")
                .build();
        recipientUserList.add(recipient1);
        //设置第二个接收人
        MsgRecipientUserDTO recipient2=MsgRecipientUserDTO.builder()
                .userId(687286284481272935L)
                .userName("test12132135")
                .build();
        recipientUserList.add(recipient2);
        dto.setRecipientUserList(recipientUserList);

        //设置抄送人： 发送邮件才会生效，其他可以不配置。
        List<MsgRecipientUserDTO> carbonUserList= new ArrayList<>();
        MsgRecipientUserDTO msgRecipientUserDTO= MsgRecipientUserDTO.builder()
                .userId(662455298723747949L)
                .userName("niuchen")
                .build();
        carbonUserList.add(msgRecipientUserDTO);
        dto.setCarbonUserList(carbonUserList);
        //配置文件编码,邮件才会生效，目前支持文件服务上传后，发送附件邮件
        dto.setFileCodes(List.of("1712040488762216448","1712040373389496320"));

        //发送人 end
        String json= null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON序列化异常：", e);
        }
        var api= sysMsgTemplateSendRpcService.msgTemplateEmployeeSend(dto);
        api.setMsg(json);
       return api ;
    }
    @PostMapping("/msgTemplateMsgTypeParamSend")
    @ApiOperation(value = "消息模板-自定义人员信息-消息发送")
    @ApiOperationSupport(order = 1)
    public ApiResult<String> msgTemplateMsgTypeParamSend(@RequestBody TemplateAssignSendParamDTO dto) {
        return  sysMsgTemplateSendRpcService.msgTemplateMsgTypeParamSend(dto);
    }


    @PostMapping("/msgTemplateMsgTypeParamSendDemo")
    @ApiOperation(value = "消息模板-自定义人员发送消息样例测试，后台组织好了固定参数，参数")
    @ApiOperationSupport(order = 99)
    public ApiResult<String> msgTemplateMsgTypeParamSendDemo(@RequestBody TemplateAssignSendParamDTO dto) {
        if(StringUtils.isBlank(dto.getTemplateCode())) {
            dto.setTemplateCode("test1");
        }
        //处理文本占位传参 start
        List<TemplateTxtReplaceDTO> templateTxtReplaceDTOS=new ArrayList<>();
        /**邮件信息动态参数设置***/
        Map emailMap=Maps.newHashMap();
        emailMap.put("name","测试模板邮件替换name");
        TemplateTxtReplaceDTO emailDTO=TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.EMAIL)
                .replaceMap(emailMap)
                .build();
        templateTxtReplaceDTOS.add(emailDTO);


        /**站内信息动态参数设置****/
        Map interiorMap=Maps.newHashMap();
        interiorMap.put("name","测试模板站内替换name");
        TemplateTxtReplaceDTO templateTxtReplaceDTO=TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.SYS_INTERIOR)
                .replaceMap(interiorMap)
                .build();
        templateTxtReplaceDTOS.add(templateTxtReplaceDTO);

        /**短信信息动态参数设置****/
        Map smsMap=Maps.newHashMap();
        smsMap.put("name","测试模板短信替换name");
        TemplateTxtReplaceDTO smsDTO= TemplateTxtReplaceDTO.builder()
                .msgSendTypeEnum(MsgSendTypeEnum.MOBILE_SMS)
                .replaceMap(interiorMap)
                .build();
        templateTxtReplaceDTOS.add(smsDTO);
        //设置内容动态参数
        dto.setMsgTemplateContentReplaceDTOS(templateTxtReplaceDTOS);

        //设置标题动态参数
        dto.setMsgTemplateTitleReplaceDTOS(templateTxtReplaceDTOS);

        //发送人设置 start
        MsgSendEmployeeUserDTO sendUser= MsgSendEmployeeUserDTO.builder()
                .userCode("adminCode")
                .userName("admin")
                .userId(26183177199419838L)
                .build();
        dto.setSendUser(sendUser);
        //发送人 end

        //接收人A设置 start
        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map1 =new HashMap<>();
        //接收人邮件
        map1.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("41614969@qq.com").build());
        //接受人手机号
        map1.put(MsgSendTypeEnum.MOBILE_SMS,
                TemplateAssignRecipientUserAccountDTO.builder().account("15136125108").build());
        List<TemplateAssignRecipientUserDTO> recipientUserList= new ArrayList<>();
        TemplateAssignRecipientUserDTO recipient1= TemplateAssignRecipientUserDTO.builder()
                .userId(26515388624798699L)
                .userName("niuchen1234")
                .recipientUserAccountDtoMap(map1)
                .build();
        recipientUserList.add(recipient1);

        //接收人B设置 start
        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map2 =new HashMap<>();
        map2.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("Kaiser.wang@elitesland.com").build());
        map2.put(MsgSendTypeEnum.MOBILE_SMS,
                TemplateAssignRecipientUserAccountDTO.builder().account("13523496731").build());
        TemplateAssignRecipientUserDTO recipient2 = TemplateAssignRecipientUserDTO.builder()
                .userId(685451965261485398L)
                .userName("WWW")
                .recipientUserAccountDtoMap(map2)
                .build();
        recipientUserList.add(recipient2);
        dto.setRecipientUserList(recipientUserList);

        //抄送人设置 只邮件生效 start
        List<TemplateAssignRecipientUserDTO> contactUserListUserList= new ArrayList<>();
        Map<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 =new HashMap<>();
        map3.put(MsgSendTypeEnum.EMAIL,
                TemplateAssignRecipientUserAccountDTO.builder().account("chen.niu@elitesland.com").build());
        TemplateAssignRecipientUserDTO recipient3=TemplateAssignRecipientUserDTO.builder()
                .userId(687286284481272935L)
                .userName("test12132135")
                .recipientUserAccountDtoMap(map3)
                .build();
        contactUserListUserList.add(recipient3);
        dto.setContactUserList(contactUserListUserList);
        //附件设置  只邮件有效
        dto.setFileCodes(List.of("file001"));

        String json= null;
        try {
            json = objectMapper.writeValueAsString(dto);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON序列化异常：", e);
        }
        var api= sysMsgTemplateSendRpcService.msgTemplateMsgTypeParamSend(dto);
        api.setMsg(json);
        return api ;
    }

    @ApiOperation(value = "测试模板转换")
    @GetMapping(value = "/testTmpl")
    public ApiResult<String> convertTemplate() {
        String tmpl = "${username}测试模板转换，待替换内容：${content}, ${username}";
        var tmplParams = Map.of("username", "张三", "content", "正式内容");
        var content = SysMsgSendCommonServiceAbstract.msgTemplateRender(tmpl, tmplParams);
        return ApiResult.ok(content);
    }


    @PostMapping("/wx/sendMsgWxBootDemo")
    @ApiOperation(value = "消息模板-员工消息发送样例测试，后台组织好了固定参数，参数")
    @ApiOperationSupport(order = 99)
    public ApiResult<String> sendMsgWxBootDemo(@RequestBody TemplateEmployeeSendParamDTO dto) {
        if(StringUtils.isBlank(dto.getTemplateCode())) {
            dto.setTemplateCode("wxboot2");
        }

        //处理内容文本占位传参 start
        Map<String, String> contentTemplateParams = new HashMap<>();
        contentTemplateParams.put("ITEM_NAME", "旺旺大礼包");
        contentTemplateParams.put("QTY", "0库存  ");
        dto.setContentReplaceMap(contentTemplateParams);

        //处理title文本占位，和内容参数一致不在重复替换
        Map<String, String> titleTemplateParams = new HashMap<>();
        titleTemplateParams.put("name", "标题替换部分");
        dto.setTitleReplaceMap(titleTemplateParams);

        var api= sysMsgTemplateSendRpcService.msgTemplateSend(dto);

        return api;
        /**邮件信息***/
    }
}
