package com.elitescloud.cloudt.system.modules.message.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;


/**
 * 消息模板主表
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 09:53
 */
@Entity
@Table(name = "sys_msg_template",indexes = {
        @Index(name = "index_msg_tmpl_templateCode", columnList = "templateCode"),
})
@org.hibernate.annotations.Table(appliesTo = "sys_msg_template", comment = "消息模板主表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "sys_msg_template", description = "消息模板主表")
public class SysMsgTemplateDO extends BaseStdModel {
    private static final long serialVersionUID = -2650466411209655794L;

    @Comment("模板编码")
    @Column(length = 200 )
    private String templateCode;

    @ApiModelProperty("模板名称")
    @Comment("模板名称")
    @Column(length = 200 )
    private String templateName;

    @Comment("模板分组-UDC")
    @Column(length = 200 )
    private String templateGroup;

    @Comment("模板描述")
    @Column(length = 500 )
    private String templateDescribe;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgTemplateDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgTemplateDO entity = (SysMsgTemplateDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}