package com.elitescloud.cloudt.system.modules.orgtree.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.modules.orgtree.model.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeComPagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.*;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(config = BaseMapperConfig.class)
public interface OrgTreeConvert {
    OrgTreeConvert INSTANCE = Mappers.getMapper(OrgTreeConvert.class);

    OrgBuTreeDTO doToDTO(OrgBuTreeDO buTreeDO);

    List<OrgBuTreeDDetailVO> treeDDDtoToVo(List<OrgBuTreeDDetailDTO> dto);

    List<OrgBuTreeDVO> treeDDtoToVo(List<OrgBuTreeDDTO> dto);

    List<OrgBuTreedAllVO> treeDAllDtoToVo(List<OrgBuTreedAllDTO> dto);

    List<OrgBuTreeVO> treeDtoToVo(List<OrgBuTreeDTO> dto);

    List<OrgBuTreePagingVO> treePDtoToVo(List<OrgBuTreePagingDTO> dto);

    /**
     * dto to vo
     *
     * @param dto dto
     * @return vo
     */
    OrgBuTreeDetailVO dtoToVo(OrgBuTreeDetailDTO dto);

    /**
     * dto to vo
     *
     * @param dto dto
     * @return vo
     */
    OrgBuTreeAndTreeDVO dtoToVo(OrgBuTreeAndTreeDDTO dto);

    /**
     * dto to vo
     *
     * @param dto dto
     * @return vo
     */
    List<OrgBuTreeComPagingVO> orgBuTreeComPagingDtoToVo(List<OrgBuTreeComPagingDTO> dto);

}
