package com.elitescloud.cloudt.system.modules.orgtree.model;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serial;

/**
 * 支持树形结构的数据需要的字段
 * @author Chris
 * @date 2021-03-14
 */
@Data
@MappedSuperclass
public class TreeModel extends BaseModel {
    @Serial
    private static final long serialVersionUID = -7070953626026704723L;
    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    @Comment("上级ID")
    @Column(length = 20, nullable = false)
    private Long pid = 0L;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column(length = 10)
    private Integer sortNo;

    /**
     * 层级
     */
    @ApiModelProperty(value = "层级")
    @Comment("层级")
    @Column(length = 10)
    private Integer level = 1;

    /**
     * 树型结构编号全路径，使用/隔离
     */
    @ApiModelProperty("树型结构编号全路径，使用/隔离")
    @Comment("树型结构编号全路径，使用/隔离")
    @Column
    private String codePath;
}
