package com.elitescloud.cloudt.system.modules.orgtree.model.param;

import com.elitescloud.cloudt.ucenter.utils.TreeNode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 组织树版本保存组织树
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/119:40
 */
@Data
public class OrgBuTreeVDSaveParam implements TreeNode<OrgBuTreeVDSaveParam> {
    private static final long serialVersionUID = -5590701948455296865L;
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 组织id
     */
    @ApiModelProperty(value = "组织id")
    private Long buId;
    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String buCode;

    /**
     * 父节点id 前端不用传
     */
    @ApiModelProperty(value = "父节点id 前端不用传")
    private Long pid;
    /**
     * 编号
     */
    @ApiModelProperty(value = "编号 前端不用传")
    private String code;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径 前端不用传")
    private String path;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别 前端不用传")
    private Integer level;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号 前端不用传")
    private Integer sortNo;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点 前端不用传")
    private Boolean isLeaf;

    /**
     * 子节点列表
     */
    private List<OrgBuTreeVDSaveParam> treeNodes;
}
