package com.elitescloud.cloudt.system.modules.orgtree.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/1114:43
 */
@Data
public class OrgBuTreeAndTreeDVO implements Serializable {
    private static final long serialVersionUID = -8495687191684334889L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    @SysCode(sys = "yst-supp", mod = "BUTREE_TYPE")
    private String buTreeType;
    private String buTreeTypeName;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    private String buTreeName;

    /**
     * 版本说明
     */
    @ApiModelProperty(value = "版本说明")
    private String versionInstruction;

    /**
     * 组织树明细树形结构
     */
    @ApiModelProperty(value = "组织树明细树形结构")
    private List<OrgBuTreeDVO> orgBuTreeDVOList;
}
