package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.*;
import com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
public interface OrgBuTreeDService {

    /**
     * 组织树明细新增
     * @param paramList
     * @return
     */
     List<OrgBuTreeDDetailVO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList);

    /**
     * 通过id查询所有下级
     * 通过id查询下一级
     * @param id
     * @param searchType
     * @param buTreeId
     * @return
     */
     List<OrgBuTreedAllVO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId);

    /**
     * 获取组织树形结构
     * @param buTreeId
     * @param searchType
     * @return
     */
     List<OrgBuTreeDVO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId);

    /**
     * 组织树节点删除
     * @param id
     */
    void deleteTreeDetail(Long id,Long buTreedId);


    /**
     * 新增组织树版本数据
     * @param param 数据参数
     */
    void saveBuTreeDV( OrgBuTreeVSaveParam param);

    /**
     * 根据组织号获取组织信息
     * @param buTreeCode 组织树编码
     * @return list
     */
    List<String> getBuTreeVersionByBuTreeCode(String buTreeCode);

    /**
     * 根据组织号获取所有组织树信息
     * @param param 组织树编码
     * @return list
     */
    List<OrgBuTreeVO> getBuTreeListByParam(OrgBuTreeVListParam param);

    /**
     * 根据param获取 组织树节点版本信息
     * @param param param
     * @return list
     */
    OrgBuTreeAndTreeDVO getBuTreeDListByParam(OrgBuTreeVListParam param);

    /**
     * 发布组织树版本
     * @param id 组织树id
     */
    void releaseBuTreeVersion(Long id);

    ApiResult<String> buTreeNodeSaveEmployee(BuTreeNodeEmployeeParam param);

    ApiResult<String> buTreeNodeDeleteEmployee(BuTreeNodeDeleteEmployeeParam param);

    ApiResult<List<EmployeePagedRespVO>> buTreeNodeQueryEmployee(BuTreeNodeQueryEmployeeParam param);

    ApiResult<String> buTreeNodeAddEmployee(BuTreeNodeEmployeeParam param);

    /**
     * 根据组织树和员工id查询本机和下级组织
     */
    ApiResult<List<EmpOrgTreeOrgDTO>> searchOrgByOrgTreeCodeAndEmpId(com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam param);}
