package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDetailVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreePagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeVO;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
public interface OrgBuTreeService {

    /**
     * 组织树新增、更新
     *
     * @param param
     * @return
     */
    Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param);

    /**
     * 通过id获取组织树详细信息，包含树状结构
     *
     * @param id
     * @return
     */
    OrgBuTreeDetailVO getOrgBuTreeDetailById(Long id);

    /**
     * 组织树分页条件查询
     *
     * @param param
     * @return
     */
    PagingVO<OrgBuTreePagingVO> queryOrgBuTreeByParams(OrgBuTreePagingParam param);

    /**
     * 组织树确认、停用
     *
     * @param param
     */
    void updateStatus(OrgBuTreeStatusParam param);

    /**
     * 根据param获取组织树履历数据
     *
     * @param param param
     * @return 分页数据
     */
    PagingVO<OrgBuTreeVO> getBuTreePagingByParam(OrgBuTreeVPagingParam param);

    /**
     * 根据组织树编码获取是否可以创建新版本组织树标识
     *
     * @param buTreeCode
     * @return
     */
    Boolean getCreateNewVersionFlag(String buTreeCode);

    OrgBuTreeDO getOrgBuTreeDetailByCode(String code);

    /**
     * 根据id删除草稿状态的组织树
     *
     * @param id 组织树id
     */
    void deleteBuTreeById(Long id);


}
