package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreedAllDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Component
@RequiredArgsConstructor
public class OrgBuTreeDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public List<OrgBuTreedAllDTO> selectByPid(Long id) {
        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        OrgBuTreedAllDTO.class,
                        orgBuTreeDDO.id,
//                        orgBuDO.buCode,
//                        orgBuDO.buName,
//                        orgBuDO.buAbbr,
//                        orgBuDO.buType,
//                        orgBuDO.buStatus,
                        orgBuTreeDDO.pid,
                        orgBuTreeDDO.level,
                        orgBuTreeDDO.sortNo
                )
        )
                .from(orgBuTreeDDO)
//                .leftJoin(orgBuDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
                .where(orgBuTreeDDO.pid.eq(id))
                .fetch();
    }

    public List<OrgBuTreedAllDTO> selectAllBuByBuTreeId(Long buTreeId) {
        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
        return jpaQueryFactory.select(
                Projections.bean(
                        OrgBuTreedAllDTO.class,
                        orgBuTreeDDO.id,
//                        orgBuDO.buCode,
                        orgBuTreeDDO.buId,
//                        orgBuDO.buName,
//                        orgBuDO.buAbbr,
//                        orgBuDO.buType,
//                        orgBuDO.buStatus,
                        orgBuTreeDDO.pid,
                        orgBuTreeDDO.level,
                        orgBuTreeDDO.sortNo
                )
        )
                .from(orgBuTreeDDO)
//                .leftJoin(orgBuDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
                .where(orgBuTreeDDO.buTreeId.eq(buTreeId))
                .fetch();
    }

//    public List<OrgBuTreeDDTO> searchByBuTreeId(Long buTreeId, String searchType) {
//        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
//        Predicate predicate = orgBuTreeDDO.buTreeId.eq(buTreeId);
//        if (!UtilEnum.CODE_TYPE.getValue().equals(searchType)) {
//            predicate = ExpressionUtils.and(predicate, orgBuDO.buStatus.notEqualsIgnoreCase(OrgUdcEnum.BU_STATUS_CLOSED.getUdcVal()));
//        }
//        return jpaQueryFactory.select(
//                Projections.bean(
//                        OrgBuTreeDDTO.class,
//                        orgBuTreeDDO.id,
//                        orgBuTreeDDO.buTreeId,
//                        orgBuTreeDDO.buId,
//                        orgBuDO.buName,
//                        orgBuDO.buAbbr,
//                        orgBuDO.buCode,
//                        orgBuDO.buType,
//                        orgBuDO.buStatus,
//                        orgBuTreeDDO.pid,
//                        orgBuTreeDDO.level,
//                        orgBuDO.sortNo
//                )
//        )
//                .from(orgBuTreeDDO)
//                .leftJoin(orgBuDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
//                .where(predicate)
//                .fetch();
//    }
//
//    public String searchBuCodeByBuTreeDId(Long buTreeDId) {
//        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
//        return jpaQueryFactory.select(orgBuDO.buCode).from(orgBuDO)
//                .leftJoin(orgBuTreeDDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
//                .where(orgBuTreeDDO.id.eq(buTreeDId)).fetchOne();
//    }

//    public Long searchBuTreeDIdByTreeCodeAndBuCode(String buTreeCode, String buCode, String buTreeVersion) {
//        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
//        var orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;
//        return jpaQueryFactory.select(orgBuTreeDDO.id).from(orgBuTreeDDO)
//                .leftJoin(orgBuDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
//                .leftJoin(orgBuTreeDO).on(orgBuTreeDO.id.eq(orgBuTreeDDO.buTreeId))
//                .where(orgBuDO.buCode.eq(buCode)
//                        .and(orgBuTreeDO.buTreeCode.eq(buTreeCode))
//                        .and(orgBuTreeDO.buTreeVersion.eq(buTreeVersion)))
//                .fetchOne();
//    }

    /**
     * 根据组织树明细id列表 获取对应的组织编码
     *
     * @param buTreeDIds 组织树明细id列表
     * @return 组织编码列表
     */
//    public List<String> searchBuCodeByBuTreeDIds(List<Long> buTreeDIds) {
//        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;
//        var orgBuDO = QOrgBuDO.orgBuDO;
//        return jpaQueryFactory.select(orgBuDO.buCode).
//                from(orgBuTreeDDO)
//                .leftJoin(orgBuDO).on(orgBuTreeDDO.buId.eq(orgBuDO.id))
//                .where(orgBuTreeDDO.id.in(buTreeDIds))
//                .fetch();
//    }

    public List<OrgBuTreeDDTO> findBuTreeDByParam(OrgBuTreeDParam param) {
        var orgBuTreeDDO = QOrgBuTreeDDO.orgBuTreeDDO;

        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getBuCode())) {
            String likeStr = "%" + param.getBuCode() + "%";
            predicates.add(orgBuTreeDDO.codePath.like(likeStr));

        }
        return jpaQueryFactory.select(
                Projections.bean(
                        OrgBuTreeDDTO.class,
                        orgBuTreeDDO.id,
                        orgBuTreeDDO.buTreeId,
                        orgBuTreeDDO.buId,
                        orgBuTreeDDO.codePath
                ))
                .from(orgBuTreeDDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }
}
