package com.elitescloud.cloudt.system.modules.warning.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRulePageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRuleDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRulePageRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.save.SysWarningRuleSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
public interface SysWarningRuleMngService {

    /**
     * 保存预警规则
     *
     * @param saveVO
     * @return
     */
    ApiResult<Long> save(SysWarningRuleSaveVO saveVO);

    /**
     * 分页查询
     *
     * @param queryVO
     * @return
     */
    ApiResult<PagingVO<SysWarningRulePageRespVO>> pageMng(SysWarningRulePageQueryVO queryVO);

    /**
     * 批量更新启用状态
     *
     * @param ids
     * @param enabled
     * @return
     */
    ApiResult<List<Long>> updateEnabled(List<Long> ids, Boolean enabled);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    ApiResult<List<Long>> delete(List<Long> ids);

    /**
     * 获取详细信息
     *
     * @param id
     * @return
     */
    ApiResult<SysWarningRuleDetailRespVO> getDetail(Long id);
}
