package com.elitescloud.cloudt.system.modules.warning.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 预警执行记录明细.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/6 周三
 */
@Entity
@Table(name = "sys_warning_record_detail", indexes = {
        @Index(name = "idx_warning_record_d_masid", columnList = "masId"),
        @Index(name = "idx_warning_record_d_doccode", columnList = "docCode"),
})
@Comment("预警执行记录明细")
@Getter
public class SysWarningRecordDetailDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = 5628270464882186570L;

    @Comment(value = "主表ID")
    @Column(nullable = false)
    private Long masId;

    @Comment(value = "业务单据ID")
    @Column()
    private Long docId;

    @Comment(value = "业务单据编号")
    @Column()
    private String docCode;

    @Comment(value = "业务单据名称")
    @Column()
    private String docName;

    @Comment(value = "是否校验通过", defaultValue = "0")
    @Column()
    private Boolean verifyPass;

    @Comment(value = "校验时间")
    @Column()
    private LocalDateTime verifyTime;

    @Comment(value = "是否已通知用户", defaultValue = "0")
    @Column()
    private Boolean noticed;

    @Comment(value = "失败原因")
    @Column()
    private String failReason;
}
