package com.elitescloud.cloudt.system.modules.warning.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningNoticeRateEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalTime;

/**
 * 预警规则.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Entity
@Table(name = "sys_warning_rule", indexes = {
        @Index(name = "idx_warning_rule_code", columnList = "ruleCode"),
        @Index(name = "idx_warning_rule_scene", columnList = "scene"),
})
@Comment("预警规则")
@Getter
@Setter
public class SysWarningRuleDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = -364101128303013690L;

    @Comment(value = "规则编码")
    @Column(nullable = false)
    private String ruleCode;

    @Comment(value = "规则名称")
    @Column(nullable = false)
    private String ruleName;

    @Comment(value = "启用状态", defaultValue = "0")
    @Column()
    private Boolean enabled;

    @Comment(value = "规则描述")
    @Column()
    private String description;

    @Comment(value = "业务场景, [UDC]cloudt-system:WARNING_SCENE")
    @Column(nullable = false)
    private String scene;

    /**
     * @see SysWarningTimeEnum
     */
    @Comment(value = "执行时间类型")
    @Column(nullable = false)
    private String execTimeType;

    @Comment(value = "执行时间值, 以逗号分隔 (周：[一、二、三、四、五、六、日]; 月[1、2、3、4等]; 自定义[yyyy-MM-dd])")
    @Column()
    private String execTimeValues;

    @Comment(value = "执行开始时间, 格式HH:mm:ss")
    @Column()
    private LocalTime execStartTime;

    @Comment(value = "是否开启工作日免打扰")
    @Column()
    private Boolean excludedWorkday;

    @Comment(value = "工作日免打扰-开始时间, 格式HH:mm:ss")
    @Column()
    private LocalTime workdayStartTime;

    @Comment(value = "工作日免打扰-截止时间, 格式HH:mm:ss")
    @Column()
    private LocalTime workdayEndTime;

    @Comment(value = "是否开启节假日免打扰")
    @Column()
    private Boolean excludedHolidays;

    /**
     * @see SysWarningNoticeRateEnum
     */
    @Comment(value = "通知频率")
    @Column()
    private String noticeRateValue;

    @Comment(value = "自定义通知频率值(分钟)")
    @Column()
    private Integer customNoticeRate;

    @Comment(value = "消息模板编码")
    @Column()
    private String noticeTmplCode;

    /**
     * @see MsgSendTypeEnum
     */
    @Comment(value = "推送方式, 多个以逗号分隔")
    @Column()
    private String sendTypes;

    @Comment(value = "推送对象-按角色", defaultValue = "0")
    @Column()
    private Boolean enabledRecvByRole;

    @Comment(value = "推送对象-角色编码, 多个以逗号分隔")
    @Column()
    private String recvRoleCodes;

    @Comment(value = "推送对象-仅针对预警对象", defaultValue = "0")
    @Column()
    private Boolean onlyPushWarningObj;

    @Comment(value = "推送对象-按用户", defaultValue = "0")
    @Column()
    private Boolean enabledRecvByUser;

    @Comment(value = "推送对象-用户ID, 多个以逗号分隔")
    @Column()
    private String recvUserIds;
}
