package com.elitescloud.cloudt.system.modules.wecom.model.department;

import com.elitescloud.cloudt.system.modules.wecom.model.BaseResult;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 部门ID列表.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/20
 */
@Getter
@Setter
public class DepartmentIdListResult extends BaseResult {
    private static final long serialVersionUID = -1651989820745352882L;

    /**
     * 部门列表
     */
    private List<DepartmentId> department_id;

    @Getter
    @Setter
    public static class DepartmentId implements Serializable {
        private static final long serialVersionUID = -4970108766633089506L;

        /**
         * 部门ID
         */
        private Long id;

        /**
         * 上级部门ID
         */
        private Long parentid;

        /**
         * 顺序
         * <p>
         * 越大越靠前
         */
        private Integer order;
    }
}
