package com.elitescloud.cloudt.system.modules.wecom.model.msg;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 基本消息.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/5 周四
 */
@Getter
@Setter
public abstract class BaseMsg implements Serializable {
    private static final long serialVersionUID = 2246939949457462050L;

    /**
     * 接收消息的成员
     * <p>
     * 指定接收消息的成员，成员ID列表（多个接收者用‘|’分隔，最多支持1000个）。
     * 特殊情况：指定为"@all"，则向该企业应用的全部成员发送
     */
    private String touser;

    /**
     * 接收消息的部门
     * <p>
     * 指定接收消息的部门，部门ID列表，多个接收者用‘|’分隔，最多支持100个。
     * 当touser为"@all"时忽略本参数
     */
    private String toparty;

    /**
     * 接收消息的标签
     * <p>
     * 标签ID列表，多个接收者用‘|’分隔，最多支持100个。
     * 当touser为"@all"时忽略本参数
     */
    private String totag;

    /**
     * 企业应用的id
     * <p>
     * 整型。可在应用的设置页面查看
     */
    private Integer agentid;

    /**
     * 是否是保密消息
     * <p>
     * 表示是否是保密消息，0表示可对外分享，1表示不能分享且内容显示水印，默认为0
     */
    private Integer safe;

    /**
     * 是否开启id转译
     * <p>
     * 0表示否，1表示是，默认0
     */
    private Integer enable_id_trans;

    /**
     * 是否开启重复消息检查
     * <p>
     * 0表示否，1表示是，默认0
     */
    private Integer enable_duplicate_check;

    /**
     * 重复消息检查的时间间隔
     * <p>
     * 单位为秒，默认1800秒
     */
    private Integer duplicate_check_interval;

    /**
     * 获取消息类型
     *
     * @return 消息类型
     */
    public abstract String getMsgtype();
}
