package com.elitescloud.cloudt.system.modules.wecom.model.user.attr;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 小程序属性.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/21
 */
@Getter
@Setter
public class MiniProgramAttr extends BaseAttr {
    private static final long serialVersionUID = -1618630087441002695L;

    /**
     * 小程序
     */
    private MiniProgram miniprogram;

    /**
     * 创建实例
     *
     * @param name
     * @param appid
     * @param pagepath
     * @param title
     * @return
     */
    public static MiniProgramAttr create(String name, String appid, String pagepath, String title) {
        MiniProgramAttr.MiniProgram miniProgram = new MiniProgramAttr.MiniProgram();
        miniProgram.setAppid(appid);
        miniProgram.setPagepath(pagepath);
        miniProgram.setTitle(title);

        MiniProgramAttr attr = new MiniProgramAttr();
        attr.setMiniprogram(miniProgram);
        attr.setType(2);
        attr.setName(name);
        return attr;
    }

    @Getter
    @Setter
    public static class MiniProgram implements Serializable {
        private static final long serialVersionUID = 600274641916110255L;

        /**
         * appId
         */
        private String appid;

        /**
         * 首页
         */
        private String pagepath;

        /**
         * 标题
         */
        private String title;
    }
}
