package com.elitescloud.cloudt.system.modules.xingyunzuo.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.modules.xingyunzuo.service.XingyunzuoService;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.Key;
import java.util.Date;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/26
 */
@Service
public class XingyunzuoServiceImpl implements XingyunzuoService {

    @Autowired
    private SystemProperties systemProperties;

    @Override
    public ApiResult<String> generateToken() {
        var props = systemProperties.getXingYunZuo();
        // 加载秘钥
        String secretKeyStr = props.getSecretKey();
        if (CharSequenceUtil.isBlank(secretKeyStr)) {
            return ApiResult.fail("未配置SecretKey，请联系管理员");
        }
        Key secretKey = Keys.hmacShaKeyFor(Base64.decode(secretKeyStr));

        String mobile = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUser().getMobile();
        if (CharSequenceUtil.isBlank(mobile)) {
            return ApiResult.fail("未获取到用户手机号");
        }

        // 过期时间
        long expirationMs = System.currentTimeMillis() + props.getTtl().toMillis();
        String jwt = Jwts.builder()
                .claim("phoneNumber", mobile)
                .claim("merchantId", props.getMerchantId())
                .claim("projectId", props.getProjectId())
                .setExpiration(new Date(expirationMs))
                .signWith(secretKey)
                .compact();

        return ApiResult.ok(jwt);
    }
}
