package com.elitescloud.cloudt.system.provider.imports;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.provider.imports.param.PageFieldImportBO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 前端配置导入.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/27
 */
@Component
public class PageFieldImportProvider implements DataImport<PageFieldImportBO> {

    @Autowired
    private SysPageFieldConfigService service;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Override
    public String getTmplCode() {
        return "sys_fieldconfig_import";
    }

    @Override
    public List<String> executeImport(List<PageFieldImportBO> dataList, int startRowIndex) {
        Map<String, String> appMap = new HashMap<>(dataList.size());
        List<String> errorMsgList = new ArrayList<>(dataList.size());

        for (PageFieldImportBO pageFieldImportBO : dataList) {
            try {
                var res = this.importData(pageFieldImportBO, appMap);
                errorMsgList.add(res);
            } catch (Exception e) {
                errorMsgList.add(e.getMessage());
            }
        }
        return errorMsgList;
    }

    @Override
    public Integer stepSize() {
        return 10;
    }

    private String importData(PageFieldImportBO importBO, Map<String, String> appMap) {
        Assert.notBlank(importBO.getAppCode(), "应用编码为空");

        String appName = appMap.computeIfAbsent(importBO.getAppCode(), code -> tenantDataIsolateProvider.byDefaultDirectly(() -> appRepoProc.getNameByCode(code)));
        Assert.notBlank(appName, importBO.getAppCode() + "不存在或错误");
        importBO.setAppName(appName);

        Assert.notBlank(importBO.getConfigCode(), "配置编码为空");
        importBO.setConfigName(CharSequenceUtil.blankToDefault(importBO.getConfigName(), importBO.getConfigCode()));
        Assert.notBlank(importBO.getFieldCode(), "字段编码为空");
        importBO.setFieldName(CharSequenceUtil.blankToDefault(importBO.getFieldName(), importBO.getFieldCode()));

        importBO.setFieldRequired(ObjectUtil.defaultIfNull(importBO.getFieldRequired(), () -> "是".equals(importBO.getFieldRequiredName())));
        importBO.setFieldOrder(ObjectUtil.defaultIfNull(importBO.getFieldOrder(), 1));
        importBO.setFieldHidden(ObjectUtil.defaultIfNull(importBO.getFieldHidden(), () -> "是".equals(importBO.getFieldHiddenName())));
        importBO.setFieldEdit(ObjectUtil.defaultIfNull(importBO.getFieldEdit(), () -> "是".equals(importBO.getFieldEditName())));

        var saveResult = service.save(importBO);
        Assert.isTrue(saveResult.isSuccess(), saveResult.getMsg());
        return null;
    }

}
