package com.elitescloud.cloudt.system.rpc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysNoticeRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysNoticeSaveDTO;
import com.elitescloud.cloudt.system.service.NoticeMngService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/29
 */
@RestController
@RequestMapping(value = SysNoticeRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysNoticeRpcServiceImpl implements SysNoticeRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SysNoticeRpcServiceImpl.class);

    @Autowired
    private NoticeMngService mngService;

    @Override
    public ApiResult<Long> publish(SysNoticeSaveDTO saveDTO) {
        return mngService.publish(saveDTO);
    }

    @Override
    public ApiResult<List<Long>> publish(List<SysNoticeSaveDTO> saveDTOList) {
        if (CollUtil.isEmpty(saveDTOList)) {
            return ApiResult.fail("公告信息为空");
        }

        List<Long> saveIds = new ArrayList<>();
        for (SysNoticeSaveDTO saveDTO : saveDTOList) {
            try {
                var id = mngService.publish(saveDTO).computeData();
                if (id != null) {
                    saveIds.add(id);
                }
            } catch (Exception e) {
                logger.error("保存公告异常：{}", JSONUtil.toJsonString(saveDTO), e);

                // 清理掉已保存的
                if (!saveIds.isEmpty()) {
                    mngService.delete(new HashSet<>(saveIds), true);
                }
            }
        }
        return ApiResult.ok(saveIds);
    }

    @Override
    public ApiResult<Long> revoke(Long id) {
        if (id == null) {
            return ApiResult.fail("公告ID为空");
        }
        return mngService.delete(Set.of(id), true).map(t -> id);
    }

    @Override
    public ApiResult<Set<Long>> revokeBatch(Set<Long> ids) {
        return mngService.delete(ids, true);
    }
}
