package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.SysUdcRpcService;
import com.elitescloud.cloudt.system.service.UdcQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/25
 */
@RestController
@RequestMapping(value = SysUdcRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUdcRpcServiceImpl implements SysUdcRpcService {

    @Autowired
    private UdcQueryService udcQueryService;

    @Override
    public ApiResult<SysUdcDTO> get(String appCode, String udcCode) {
        return udcQueryService.get(appCode, udcCode);
    }

    @Override
    public ApiResult<List<SysUdcDTO>> listByUdcCode(String appCode, Set<String> udcCodes) {
        return udcQueryService.listByUdcCode(appCode, udcCodes);
    }
}
