package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.dto.SysUserTerminalSaveDTO;
import com.elitescloud.cloudt.system.provider.SysUserTerminalRpcService;
import com.elitescloud.cloudt.system.service.SysUserTerminalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/29
 */
@RestController
@RequestMapping(value = SysUserTerminalRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUserTerminalRpcServiceImpl implements SysUserTerminalRpcService {

    @Autowired
    private SysUserTerminalService userTerminalService;

    @Override
    public ApiResult<Long> save(SysUserTerminalSaveDTO saveParam) {
        return userTerminalService.save(saveParam);
    }

    @Override
    public ApiResult<Long> saveForAdd(SysUserTerminalSaveDTO saveParam) {
        return userTerminalService.saveForAdd(saveParam);
    }

    @Override
    public ApiResult<Long> saveForReduce(SysUserTerminalSaveDTO saveParam) {
        return userTerminalService.saveForReduce(saveParam);
    }

    @Override
    public ApiResult<List<Terminal>> getByUser(Long userId) {
        return userTerminalService.getByUser(userId);
    }

    @Override
    public ApiResult<List<Terminal>> getByUsername(String username) {
        return userTerminalService.getByUser(username);
    }

    @Override
    public ApiResult<Map<Long, List<Terminal>>> getByUserIds(List<Long> userIds) {
        return userTerminalService.getByUser(userIds);
    }
}
