package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.system.provider.imports.param.ImportAreaBO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/30
 */
public interface AreaMngService {

    /**
     * 获取是否启用平台设置
     *
     * @return 是否启用平台设置
     */
    ApiResult<Boolean> getEnabledPlatform();

    /**
     * 设置是否启用平台设置
     *
     * @return 设置结果
     */
    ApiResult<Boolean> updateEnabledPlatform();

    /**
     * 行政区域树
     *
     * @param tree 是否返回树状数据
     * @return 树列表
     */
    ApiResult<List<AreaMngTreeRespVO>> tree(Boolean tree);

    /**
     * 保存行政区域
     *
     * @param saveVO 行政区域信息
     * @return 区域ID
     */
    ApiResult<Long> save(PlatformAreaSaveVO saveVO);

    /**
     * 保存行政区域
     *
     * @param areaBO 行政区域信息
     * @return ID
     */
    ApiResult<Long> save(ImportAreaBO areaBO);

    /**
     * 获取行政区域详情
     *
     * @param id 区域ID
     * @return 区域详情
     */
    ApiResult<AreaDetailRespVO> get(Long id);

    /**
     * 删除行政区域详情
     *
     * @param id 区域ID
     * @return 区域详情
     */
    ApiResult<Long> delete(Long id);

    /**
     * 重构行政树
     *
     * @param rootId 根节点ID
     * @return 行政树
     */
    ApiResult<Boolean> rebuildTree(Long rootId);

    /**
     * 获取采集地址
     *
     * @return
     */
    ApiResult<String> grabUrl();

    /**
     * 采集预览
     *
     * @param url
     * @param forceLevel 是否强制3级
     * @return
     */
    ApiResult<Object> grabPreview(String url, Boolean forceLevel, Boolean json);

    /**
     * 采集
     *
     * @param url
     * @param forceLevel 是否强制3级
     * @return
     */
    ApiResult<Boolean> grab(String url, Boolean forceLevel);
}
