package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.model.dto.SysBusinessObjectDTO;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectTreeNodeRespVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/19
 */
public interface BusinessObjectQueryService {

    /**
     * 业务对象树
     *
     * @param tree           是否返回树状
     * @param withApp        是否显示APP
     * @param withOperation  是否显示操作
     * @param withRef        是否显示关联的
     * @param permissionOnly 是否仅返回有权限的
     * @return 业务对象列表
     */
    ApiResult<List<BusinessObjectTreeNodeRespVO>> businessObjectTree(Boolean tree, Boolean withApp, Boolean withOperation,
                                                                     Boolean withRef, Boolean permissionOnly);

    /**
     * 获取所有的业务对象信息
     *
     * @return
     */
    ApiResult<List<SysBusinessObjectDTO>> allBusinessObject();

    /**
     * 获取业务对象详细信息
     *
     * @param businessObjectCode 业务对象编码
     * @return
     */
    ApiResult<SysBusinessObjectDTO> getBusinessObjectDetail(@NotBlank String businessObjectCode);


    /**
     * 获取所有的业务操作
     *
     * @return 业务操作列表
     */
    ApiResult<List<SysBusinessOperationDTO>> allOperationDTO();
}
