package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonEmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeeListQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/2
 */
public interface EmployeeQueryService {

    /**
     * 分页查询员工信息
     *
     * @param queryVO 查询参数
     * @return 查询结果
     */
    ApiResult<PagingVO<EmployeePagedRespVO>> pageQuery(CommonEmployeePageQueryVO queryVO);

    /**
     * 分页查询员工
     *
     * @param queryDTO 查询参数
     * @return 员工列表
     */
    ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(EmployeePageQueryDTO queryDTO);

    /**
     * 获取员工的业务员ID
     *
     * @param id 员工ID
     * @return 业务员ID
     */
    ApiResult<List<String>> getSalesmanId(@NotNull Long id);

    /**
     * 获取员工的业务员ID
     *
     * @param userId 账号ID
     * @return 业务员ID
     */
    ApiResult<List<String>> getSalesmanIdByUserId(@NotNull Long userId);

    /**
     * 查询员工列表
     * <p>
     * 查询条件为空时返回空集合
     *
     * @param queryVO 查询参数
     * @return 员工列表
     */
    ApiResult<List<EmployeeListRespVO>> listQuery(EmployeeListQueryVO queryVO);

    /**
     * 获取员工编码
     *
     * @param id
     * @return
     */
    ApiResult<String> getCode(@NotNull Long id);

    /**
     * 获取账号ID
     * @param id
     * @return
     */
    ApiResult<Long> getUserId(@NotNull Long id);

    /**
     * 获取登录号
     *
     * @param id
     * @return
     */
    ApiResult<String> getUsername(@NotNull Long id);

    /**
     * 根据ID获取员工信息
     *
     * @param id 员工ID
     * @return
     */
    ApiResult<SysEmployeeBasicDTO> getById(@NotNull Long id);

    /**
     * 根据员工编号获取员工信息
     *
     * @param code 员工编号
     * @return
     */
    ApiResult<SysEmployeeBasicDTO> getByCode(@NotBlank String code);

    /**
     * 根据登录号获取员工信息
     *
     * @param username 登录账号
     * @return
     */
    ApiResult<SysEmployeeBasicDTO> getByUsername(@NotBlank String username);

    /**
     * 根据用户ID获取用户信息
     *
     * @param userId 用户ID
     * @return
     */
    ApiResult<SysEmployeeBasicDTO> getByUserId(@NotNull Long userId);

    /**
     * 根据员工ID获取详细信息
     *
     * @param id 员工ID
     * @return 详细信息
     */
    ApiResult<SysEmployeeDetailDTO> getDetailById(@NotNull Long id);

    /**
     * 根据员工编号获取详细信息
     *
     * @param code 员工编号
     * @return 详细信息
     */
    ApiResult<SysEmployeeDetailDTO> getDetailByCode(@NotBlank String code);

    /**
     * 根据用户ID获取详细信息
     *
     * @param userId 账号ID
     * @return 详细信息
     */
    ApiResult<SysEmployeeDetailDTO> getDetailByUserId(@NotNull Long userId);

    /**
     * 根据员工账号获取详细信息
     *
     * @param username 登录张阿红
     * @return 详细信息
     */
    ApiResult<SysEmployeeDetailDTO> getDetailByUsername(@NotBlank String username);

    /**
     * 根据员工编号获取详细信息
     *
     * @param codes 员工编号
     * @return 详细信息
     */
    ApiResult<List<SysEmployeeDetailDTO>> getDetailListByCode(@NotEmpty Set<String> codes);

    /**
     * 获取下属员工
     *
     * @param code    员工编号
     * @param cascade 是否级联获取所有下属员工
     * @param enabled 员工启用状态
     * @return 员工列表
     */
    ApiResult<List<EmployeeUnderlingDTO>> getUnderlingByCode(@NotBlank String code, Boolean cascade, Boolean enabled);

    /**
     * 获取下属ID
     *
     * @param id 员工ID
     * @return 下属ID
     */
    ApiResult<List<SysUnderlingDTO>> getUnderlingId(@NotNull Long id);

    /**
     * 查询员工列表
     *
     * @param queryDTO
     * @return
     */
    ApiResult<List<SysEmployeeBasicDTO>> queryList(@NotNull EmployeeQueryDTO queryDTO);

    /**
     * 获取下属员工的用户ID
     *
     * @param leaderUserId 领导用户ID
     * @return 下属员工的用户ID
     */
    ApiResult<List<Long>> getUserIdByLeaderUserId(@NotNull Long leaderUserId);

    /**
     * 获取员工的组织名称
     *
     * @param ids 员工ID
     * @return 员工ID与组织名称
     */
    ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeOrgs(List<Long> ids);

    /**
     * 判断员工编号是否存在
     *
     * @param code 员工编号
     * @return 是否存在
     */
    ApiResult<Boolean> existsCode(@NotBlank String code);

    /**
     * 查询员工编号和姓名
     *
     * @param ids 员工ID
     * @return
     */
    ApiResult<List<IdCodeNameParam>> queryCodeName(Set<Long> ids);

    /**
     * 查询员工编号和姓名
     *
     * @param codes 员工编号
     * @return
     */
    ApiResult<List<IdCodeNameParam>> queryCodeNameByCode(Set<String> codes);

    /**
     * 查询员工编号和姓名
     *
     * @param userIds 员工账号ID
     * @return
     */
    ApiResult<List<IdCodeNameParam>> queryCodeNameByUserId(Set<Long> userIds);
}
